package simpleDist;

import java.net.*;
import java.io.*;
import javax.swing.*;
import javax.net.ssl.*;
/**
 * Client is the base class for creating clients within the simpleDist package
 *
 * @author      Neil Urquhart
 * @version     1
 */

public class Client{
  private static ObjectOutputStream oos = null;
  private static ObjectInputStream ois = null;
  private static Socket socket = null;
  static boolean connected = false;
  private static ClntFrm hci;
  protected static String ip;
  protected static int port;
  protected static boolean cLuseSSL=false;
  protected static String cLkeyStore;
  protected static String cLpassword;


  public static void useClientSSL(String key, String pword){
    cLuseSSL = true;
    cLkeyStore = key;
    cLpassword = pword;
  }

   /**
     * Connects the client object to the specified server.
     *
     * @param server    ip address of the server
     * @param port      port number of server is converted.  May be <code>null</code>
     * @return          true if connected, false if no connection made
     *
     */

  public static synchronized boolean connect(String server, int servPort){
    try{
      if (hci !=null){
        hci.hide();
        hci = null;
      }
      hci = new ClntFrm();
      hci.setBounds(10,10,300,90);
      hci.setVisible(true);
      hci.setTitle("Attempting to connect ...");
      hci.setInfo(server, ""+servPort);
      System.out.println("Trying to connect to server " + server);
      if (!cLuseSSL){
        socket = new Socket(server, servPort);
      }
      else{
         /* SSL support amendment*/
         System.setProperty("javax.net.ssl.trustStore", cLkeyStore);
         System.setProperty("javax.net.ssl.trustStorePassword",cLpassword);
         System.out.println("SSL connection:" +cLkeyStore +" - "+cLpassword);
         SSLSocketFactory sslsocketfactory = (SSLSocketFactory) SSLSocketFactory.getDefault();
         socket = (SSLSocket) sslsocketfactory.createSocket(server, servPort);
         /* End of SSL support ammendment */
      }
      System.out.println("Connected to server " + socket);

      oos = new ObjectOutputStream(socket.getOutputStream());
      ois = new ObjectInputStream(socket.getInputStream());
      connected = true;
      hci.setTitle("Connected ");
      if (cLuseSSL)
        hci.setTitle("Connected (SSL)");

      port = servPort;
      ip = server;
      return true;
      }
    catch(Exception e){
      System.out.println("Cannot connect to "+ server + " \n" +e );
      hci.setTitle("Error- cannot connect.");
      connected = false;
      return false;
    }
  }

   /**
     * Sends an object to the server (Object must be serializable).
     *
     * @param obj	the object to be serialised and sent.
     * @return          true if sent, false if an error  occurs
     *
     */
  public static synchronized boolean send(Object obj){
  try{
    oos.writeObject(obj);
    oos.flush();
    oos.reset();
    return true;
    }
  catch(Exception e){
      System.out.println("Error \n" +e );
      connected = false;
      return false;
    }
  }

   /**
     * Waits for an object to be sent from the server.
     *
     * @return an object of type Object or null if an error occurs
     *
     */
  public static synchronized Object receive(){
  try{
    Object i = ois.readObject();
    return i;
    }
  catch(Exception e){
      System.out.println("Error \n" +e );
      connected = false;
      return null;
    }
  }

   /**
     * Disconnects from the server
     *
     * @return true if disconnected, false if an error has occured
     *
     */
  public static synchronized boolean disconnect(){
  try{
    socket.close();
    connected = false;
    return true;
    }
  catch(Exception e){
      System.out.println("Error \n" +e );
      return false;
    }
  }
}