package simpleDist;

import java.net.*;
import java.io.*;

/**
 * Client is the base class for creating server handlers within the simpleDist package. Each handler
 * must have a run() method which is called by default when the thread is started.
 *
 * @author      Neil Urquhart
 * @version     1
 */
public class Handler extends Thread{
  private Socket clntSock =null;
  protected Server server = null;
  private OutputStream out = null;
  private InputStream in = null;

  private ObjectInputStream ois = null;
  private ObjectOutputStream oos = null;

   /**
     * Returns a string representation of the handler.
     *
     * @return      a string containing connection details of the client the handler is connected to
     *
     */
  public String toString(){
    return clntSock.getInetAddress()+":" +clntSock.getLocalPort()+"\n";
    }

   /**
     * Initialised the handler, prior to thread execution being commenced
     *
     * @param s		the client socket object the handler must communicate through
     * @param bs 	the Server object the handler is linked to
     *
     */
  public void init(Socket s, Server bs){

    clntSock = s;
    server = bs;
    System.out.println("Connection recieved from " +s);
    try{
      ois = new ObjectInputStream(s.getInputStream());
      oos = new ObjectOutputStream(s.getOutputStream());

      }catch (IOException e){
        System.out.println(e);
       }
     }

   /**
     * Sends an object to the client (Object must be serializable).
     *
     * @param obj	the object to be serialised and sent.
     * @return          true if sent, false if an error  occurs
     *
     */
  public boolean send(Object i){
  try{
    //temp mod...
    oos.writeObject(i);
    oos.flush();
    oos.reset();
    return true;
    }
    catch (Exception e){
      System.out.println("Error \n "+e);
      return(false);
    }
  }

   /**
     * Recieves an object from the client (Object must be serializable).
     *
     * @return     an Object or null if an error has occured.
     *
     */
  public Object receive(){
  try{
    Object i = ois.readObject();
    return i;
    }
    catch (Exception e){
      System.out.println("Error \n "+e);
      return null;
    }
  }

   /**
     * Closes the client socket.
     *
     * @return          true if closed, false if an error  occurs
     *
     */
  public boolean disconnect(){
  try{
    clntSock.close();
    return true;
    }
  catch(Exception e){
    System.out.println("Error \n" +e  );
    return false;
    }
  }
}