package simpleDist;

import java.net.*;
import java.io.*;
import java.lang.*;
import java.lang.reflect.*;
import java.util.*;

import javax.net.ssl.*;

/**
 * Server is used to create multi-threaded servers within the simpleDist package. Server will coordinate  * a number of  handlers ( 1 per client) and may contain a number of objects within the repository.  * Objects within the repository may be added, deleted or modified by handlers.
 *
 * @author      Neil Urquhart
 * @version     1
 */

public class Server{
  private ArrayList handlers = new ArrayList();
  private TreeMap repos = new TreeMap();
  private TreeMap locked = new TreeMap();
  private FrmServer hci;
  private boolean useSSL = false;
  private String keyStore;
  private String password;
  private Client master=new Client();
  private boolean useMaster=false;
/*
  public void setMaster(String ip, int port){
    master.ip = ip;
    master.port = port;
    useMaster= true;
  }

  public Client masterConnect(){
    master.disconnect();
    master.connect(master.ip,master.port);
    return master;
  }
*/
  public void masterDisconnect(){
    master.disconnect();
  }

  public void useSSL(String key, String pword){
    useSSL = true;
    keyStore = key;
    password = pword;
  }


   /**
     * Returns the number of objects contained in the repository
     *
     * @return          true if sent, false if an error  occurs
     *
     */
  public synchronized int getReposSize(){
    return (repos.entrySet().size());
  }

   /**
     * Returns a ref  to the repository.
     *
     * @return   a clone of the repository
     *
     */

  public synchronized TreeMap getRepository(){
    try{
      return (TreeMap) repos.clone();
      }
      catch(Exception e){
        System.out.println(e);
        return null;
      }
    }

   /**
     * Adds an item to the repository.
     *
     * @param key   a unique key that identifies this object
     * @param item  item to add to the repository
     *
     */

  public synchronized void put(Object key,Object item){
    repos.put(key,item);
    hci.updateObjects(repos,locked);
    }

   /**
     * Confirms the existence of an object in the repository
     * @param key the key of the object being searched for
     * @return   true if key found else false
     *
     */
  public boolean exists(Object key){
    hci.updateObjects(repos,locked);
    return (repos.containsKey(key)||locked.containsKey(key));
  }

   /**
     * Deletes an object from the repository
     * @param key the key of the object to be deleted
     *
     */
  public synchronized void del(Object key){
    repos.remove(key);
    hci.updateObjects(repos,locked);
  }

   /**
     * Returns a clone of an object in the repository
     * @param key the key of the object
     * @return   the object or null if key not found
     *
     */
  public synchronized Object get(Object key){
    try{
      Object i = repos.get(key);
      if (i != null){//Use reflection to invoke the clone() method
        Class c = i.getClass();
        Class[] f = new Class[0];
        Method m = c.getMethod("clone",f);
        Object n = m.invoke(i,null);
        return n;
        }
      else
        return null;
      }

    catch (Exception e){
      System.out.println("Error " + e);
      System.exit(-1);
      }
    hci.updateObjects(repos,locked);
    return null;
    }

   /**
     * Returns true/false if an object is locked
     * @param key the key of the object to be locked
     * @return   true if locked else false
     *
     */
  public synchronized boolean isLocked(Object key){
    return locked.containsKey(key);
  }

   /**
     * Locks an object for use by the current client
     * @param key the key of the object to be locked
     * @return  a reference to the object else null if it is already locked or key not found
     *
     */
  public synchronized Object lock(Object key){
    if (locked.containsKey(key))
      return null;
    Object i = repos.get(key);
    if ( i != null){
      locked.put(key, i);
      hci.updateObjects(repos, locked);
      }
    return i;
    }

   /**
     * Called by a handler prior to destruction to remove it from the server
     * @param h reference to the Handler to be removed
     *
     */
  public void disconnect(Handler h){
    h.disconnect();
    handlers.remove(h);
    hci.updateUsers(handlers);
    }

   /**
     * Unlocks an object
     * @param key the key of the object to be unlocked
     * @return   true if unlocked else false
     *
     */
  public synchronized void unlock(Object key){
    Object i = locked.remove(key);
     if ( i != null){
       repos.put(key, i);
       hci.updateObjects(repos,locked);
       }
    }

   /**
     * Default constructor
     *
     */
  public Server(){
    hci = new FrmServer();
    hci.show();
  }

  /**
   * Connects to the master server and downloads the new catalogue.
   * Obviously if there is no master server then nothing happens ....
   *
   * If you find that the server is NOT downloading changes, restart the server
   * (leave the MasterServer running) and the system should synchronise.
   */
  /*
  public void refreshMaster(){
    if (useMaster){
      try{
        master.connect(master.ip, master.port);
        //Connect to master
        master.send("get");
        TreeMap t = (TreeMap) master.receive();
        //kill repos

        repos = t;
        hci.updateObjects(repos, locked);
        master.disconnect();
      }catch(Exception e){
        System.out.println("Update error, cannot contact master");
      }
    }
  }*/
   /**
     * Starts the execution of the server
     * @param servPort the port number on which to listen for connections
     * @param handlerCls a string containing the name of the compiled handler class
     *
     */
  public void start(int servPort, String handlerCls ) {
  try{
    hci.updateObjects(repos,locked);

    ServerSocket servSock;
    if (!useSSL){
      servSock = new ServerSocket(servPort, 1);
    }else{
      System.setProperty("javax.net.ssl.keyStore", this.keyStore);
      System.setProperty("javax.net.ssl.keyStorePassword",this.password);
      SSLServerSocketFactory sslserversocketfactory =
                   (SSLServerSocketFactory) SSLServerSocketFactory.getDefault();
     servSock =
                   (SSLServerSocket) sslserversocketfactory.createServerSocket(servPort/*,1*/);
    }

    servSock.setSoTimeout(1000);
    hci.setTitle("Server ");
    InetAddress me = InetAddress.getLocalHost();
    hci.updateStatus(me.toString(),""+servSock.getLocalPort(), handlerCls);
    int alive=0;
    int maxClients = 10;
    for(;;){
      hci.updateObjects(repos,locked);
      boolean accepted = false;
      Socket clntSock = null;
      //refreshMaster();

      while (!accepted) {
        alive++;
        /*if ((alive % 10) == 0){
          refreshMaster();
        }*/

        if (alive == Integer.MAX_VALUE)
          alive=0;
        try {
          if(handlers.size() == maxClients){
            Thread.yield();
            servSock.close();
            }
          else{
            if (servSock.isClosed()){
              if (!useSSL){
                servSock = new ServerSocket(servPort/*, 1*/);
              }else{
                SSLServerSocketFactory sslserversocketfactory =
                    (SSLServerSocketFactory) SSLServerSocketFactory.
                    getDefault();
                servSock = (SSLServerSocket) sslserversocketfactory.
                    createServerSocket(servPort, 1);
              }
            }
            if (!useSSL)
              clntSock = servSock.accept();
            else
              clntSock = (SSLSocket) servSock.accept();

            accepted = true;
            }
          }
        catch (InterruptedIOException e) {
          System.out.println("V1.1 "+ alive + "Waiting \n" + handlers);
          }
      }
      Handler h = null;
      //Handler must be instanciated via a string
      try{
        Class c =  Class.forName(handlerCls);
        h = (Handler) c.newInstance();
      }
      catch(Exception e){
        System.out.println("Error \n" +e);
        System.exit(-1);
        }
      h.init(clntSock,this);
      handlers.add(h);
      hci.updateUsers(handlers);
      hci.updateObjects(repos,locked);
      h.start();
    }
  }catch (Exception e){
    System.out.println("Error \n" + e);
    System.out.println("Properties "+System.getProperties());
    System.exit(-1);
    }
  }
}
